﻿using System;
using System.Collections.Generic;
using System.Threading;
namespace PerformanceTesting
{
    public enum ExpectedResponse { IsLoggedOn, IsNotException }
    public enum HttpCommand { GET, POST }

    [Serializable]
    public class Step : IStep
    {
        public int Index { get; set; }
        public string Action { get; set; }
        public HttpCommand Command { get; set; }
        public List<Parameter> Parameters { get; set; }
        public ExpectedResponse Result { get; set; }
        public bool WaitForAllBeforeNextStep { get; set; }

        public bool SkipLogging { get; set; }

        public Step() 
        {
            Parameters = new List<Parameter>();
        }

        public IDialog Run(IDialog dialog, Barrier stepBarrier)
        {
            Func<string, bool> validator;
            if(Result == ExpectedResponse.IsNotException)
                validator = Utils.IsNotException;
            else
                validator = Utils.IsLoggedOn;

            IDialog result = null;
            try
            {
                if (Command == HttpCommand.GET)
                    result = dialog.Get(Action, Parameters.ToNameValueCollection(), validator, SkipLogging);
                if (Command == HttpCommand.POST)
                    result = dialog.Post(Action, Parameters.ToNameValueCollection(), validator, SkipLogging);
            }
            catch (Exception e)
            {
                Logger.LogException(e);
            }
            finally 
            {
                if (WaitForAllBeforeNextStep)
                    stepBarrier.SignalAndWait();
            }
            return result;
        }
    }
}
